﻿using NVCC.Models;
using NVCC.WebUI.Infrastructure;
using NVCC.WebUI.Models;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;

namespace NVCC.WebUI.Utilities
{
    public class CustomWebRequest
    {
        public static string ExecuteRequest(string url, string env, string authToken = null, PatientProfileViewModel patientProfileViewModel = null)
        {
            string xmlString = string.Empty;
            if (!string.IsNullOrEmpty(url))
            {
                // These 2 lines below take care of :SSL connect error
                ServicePointManager.Expect100Continue = true;
                ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;

                //This line handle the cert error:The remote certificate is invalid according to the validation procedure. 
                ServicePointManager.ServerCertificateValidationCallback += (o, c, ch, er) => true;

                //Remove any spaces from the url
                url = Regex.Replace(url, @"\s+", "");

                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
                request.AutomaticDecompression = DecompressionMethods.GZip;

                // Add these headers when communicating with studies & Imaging services
                if (patientProfileViewModel != null)
                {
                    if (!string.IsNullOrEmpty(patientProfileViewModel.UserName))
                        request.Headers.Add("xxx-fullname", patientProfileViewModel.UserName);
                    if (patientProfileViewModel.PatientProfile.UserInfo.Facilities.Count > 0 && patientProfileViewModel.PatientProfile.Patient.Station >= 0)
                        request.Headers.Add("xxx-sitename", patientProfileViewModel.PatientProfile.UserInfo.Facilities[patientProfileViewModel.PatientProfile.Patient.Station].LocationName);
                    if (patientProfileViewModel.PatientProfile.Patient.Station >= 0)
                        request.Headers.Add("xxx-sitenumber", patientProfileViewModel.PatientProfile.Patient.Station.ToString());
                    if (!string.IsNullOrEmpty(generateID()))
                        request.Headers.Add("xxx-transaction-id", generateID());
                    if (env == "prod")
                    {
                        request.Headers.Add("Authorization", "Basic " + authToken);
                    }
                    else
                    {
                        request.Headers.Add("Authorization", "Basic " + authToken);
                    }
                }
                xmlString = getResponse(request);
            }
            return xmlString;
        }

        public static async Task<string> ExecuteStudyRequest(string rootUrl, string url, string env, string authToken, PatientProfileViewModel patientProfileViewModel = null)
        {

            string xmlString = string.Empty;
            if (!string.IsNullOrEmpty(url))
            {
                // These 2 lines below take care of :SSL connect error
                ServicePointManager.Expect100Continue = true;
                ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;

                //This line handle the cert error:The remote certificate is invalid according to the validation procedure. 
                ServicePointManager.ServerCertificateValidationCallback += (o, c, ch, er) => true;

                //Remove any spaces from the url
                url = Regex.Replace(url, @"\s+", "");
                rootUrl = Regex.Replace(rootUrl, @"\s+", "");

                var httpClient = new HttpClient();
                httpClient.BaseAddress = new Uri(rootUrl);


                // Add these headers when communicating with studies  & Imaging services
                if (patientProfileViewModel != null)
                {
                    if (!string.IsNullOrEmpty(patientProfileViewModel.UserName))
                        httpClient.DefaultRequestHeaders.Add("xxx-fullname", patientProfileViewModel.UserName);
                    if (patientProfileViewModel.PatientProfile.UserInfo.Facilities.Count > 0 && patientProfileViewModel.PatientProfile.Patient.Station >= 0)
                        httpClient.DefaultRequestHeaders.Add("xxx-sitename", patientProfileViewModel.PatientProfile.UserInfo.Facilities[patientProfileViewModel.PatientProfile.Patient.Station].LocationName);
                    if (patientProfileViewModel.PatientProfile.Patient.Station >= 0)
                        httpClient.DefaultRequestHeaders.Add("xxx-sitenumber", patientProfileViewModel.PatientProfile.Patient.Station.ToString());
                    if (!string.IsNullOrEmpty(generateID()))
                        httpClient.DefaultRequestHeaders.Add("xxx-transaction-id", generateID());
                    if (env == "prod")
                    {
                        httpClient.DefaultRequestHeaders.Authorization = new System.Net.Http.Headers.AuthenticationHeaderValue("Basic", authToken);
                    }
                    else
                    {
                        httpClient.DefaultRequestHeaders.Authorization = new System.Net.Http.Headers.AuthenticationHeaderValue("Basic", authToken);
                    }
                }

                try
                {
                    using (var response = await httpClient.GetAsync(url))
                    {

                        if (response.IsSuccessStatusCode)
                        {

                            using (Stream stream = await response.Content.ReadAsStreamAsync())
                            using (StreamReader reader = new StreamReader(stream))
                            {
                                xmlString = reader.ReadToEnd();
                            }

                        }
                        else
                        {
                            throw new Exception(response.StatusCode.ToString());
                        }
                    }
                }
                catch
                {
                    // We are not logging error here cause that will spam the DB.
                    return null;
                }
            }
            return xmlString;
        }

        public static async Task<VistAImagingFile> ExecuteImageRequest(string url, string imageUrn,string env, string authToken = null, PatientProfileViewModel patientProfileViewModel = null)
        {
            if (string.IsNullOrWhiteSpace(imageUrn))
            {
                return null;
            }
            VistAImagingFile vistAFile = null;
            if (!string.IsNullOrEmpty(url))
            {
                // These 2 lines below take care of :SSL connect error
                ServicePointManager.Expect100Continue = true;
                ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;

                //This line handle the cert error:The remote certificate is invalid according to the validation procedure. 
                ServicePointManager.ServerCertificateValidationCallback += (o, c, ch, er) => true;

                var httpClient = new HttpClient();
                httpClient.BaseAddress = new Uri(url);


                // Add these headers when communicating with studies  & Imaging services
                if (patientProfileViewModel != null)
                {
                    if (!string.IsNullOrEmpty(patientProfileViewModel.UserName))
                        httpClient.DefaultRequestHeaders.Add("xxx-fullname", patientProfileViewModel.UserName);
                    if (patientProfileViewModel.PatientProfile.UserInfo.Facilities.Count > 0 && patientProfileViewModel.PatientProfile.Patient.Station >= 0)
                        httpClient.DefaultRequestHeaders.Add("xxx-sitename", patientProfileViewModel.PatientProfile.UserInfo.Facilities[patientProfileViewModel.PatientProfile.Patient.Station].LocationName);
                    if (patientProfileViewModel.PatientProfile.Patient.Station >= 0)
                        httpClient.DefaultRequestHeaders.Add("xxx-sitenumber", patientProfileViewModel.PatientProfile.Patient.Station.ToString());
                    if (!string.IsNullOrEmpty(generateID()))
                        httpClient.DefaultRequestHeaders.Add("xxx-transaction-id", generateID());
                    if (env == "prod")
                    {
                        httpClient.DefaultRequestHeaders.Authorization = new System.Net.Http.Headers.AuthenticationHeaderValue("Basic", authToken);
                    }
                    else
                    {
                        httpClient.DefaultRequestHeaders.Authorization = new System.Net.Http.Headers.AuthenticationHeaderValue("Basic", authToken);
                    }
                }

                try
                {
                    using (var response = await httpClient.GetAsync("ImageWebApp/image?" + imageUrn))
                    {
                       
                        if (response.IsSuccessStatusCode)
                        {
                            var types = response.Headers.GetValues("xxx-image-format");
                            var type = types != null && types.Any() ? types.FirstOrDefault() : string.Empty;
                            type = type.ToLower();

                            if (!type.Contains("jpeg")
                                && !type.Contains("png")
                                && !type.Contains("gif")
                                && !type.Contains("bmp")
                                && !type.Contains("pdf"))
                            {
                                return null;
                            }

                            Stream imageStream = await response.Content.ReadAsStreamAsync();
                            vistAFile = new VistAImagingFile
                            {
                                FileBytes = new byte[imageStream.Length],
                                FileType = type
                            };

                            imageStream.Read(vistAFile.FileBytes, 0, (int)imageStream.Length);
                        }
                    }
                }
                catch
                {
                    // We are not logging error here cause that will spam the DB with thousands of images errors.
                    return null;
                }
            }
            return vistAFile;
        }

        public static string getResponse(HttpWebRequest request)
        {
            string xmlString = string.Empty;
            try
            {
                using (HttpWebResponse response = (HttpWebResponse)request.GetResponse())
                {
                    using (Stream stream = response.GetResponseStream())
                    using (StreamReader reader = new StreamReader(stream))
                    {
                        xmlString = reader.ReadToEnd();
                    }
                }
            }
            catch (Exception ex)
            {
                Elmah.ErrorSignal.FromCurrentContext().Raise(ex);
                if (ex.Message.Contains("(403)") || ex.Message.Contains("Forbidden"))
                {
                    return "Forbidden";
                }
                if (ex.Message.Contains("(404)") || ex.Message.Contains("Not Found"))
                {
                    return "NotFound";
                }
                if (ex.Message.Contains("(600)"))
                {
                    return "SIGNONS";
                }
            }
            return xmlString;
        }
        public static string generateID()
        {
            return Guid.NewGuid().ToString("N");
        }
    }
}